/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.lazrslib.common.network;

import com.lazrproductions.lazrslib.LazrsLibMod;
import com.lazrproductions.lazrslib.common.network.exception.InvalidLazrNetworkParameterException;
import com.lazrproductions.lazrslib.common.network.packet.ParameterizedLazrPacket;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class LazrNetworkedParameterHandler {
    public static final <T extends ParameterizedLazrPacket> void writePacketParameters(Object[] parameters, FriendlyByteBuf buffer) {
        buffer.writeInt(parameters.length);
        for (Object p : parameters) {
            buffer.m_130087_(LazrNetworkedParameterHandler.serialize(p));
        }
    }

    public static final <T extends ParameterizedLazrPacket> void readPacket(T packet, FriendlyByteBuf buffer) {
        ArrayList<Object> list = new ArrayList<Object>(0);
        int length = buffer.readInt();
        for (int i = 0; i < length; ++i) {
            Object obj = LazrNetworkedParameterHandler.deserialize(buffer.m_130052_());
            list.add(obj);
        }
        packet.setFrom(list.toArray());
    }

    static final byte[] serialize(@Nonnull Object obj) {
        byte[] byArray;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)bos);
        try {
            out.writeObject(obj);
            out.flush();
            out.close();
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new InvalidLazrNetworkParameterException("Could not serialize network parameter of type " + obj.getClass().getName(), ex);
            }
        }
        out.close();
        return byArray;
    }

    static final Object deserialize(byte[] bytes) {
        Object object;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bis);
        try {
            Object o = in.readObject();
            in.close();
            object = o;
        }
        catch (Throwable o) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable) {
                    o.addSuppressed(throwable);
                }
                throw o;
            }
            catch (Exception ex) {
                InvalidLazrNetworkParameterException e = new InvalidLazrNetworkParameterException("Could not deserialize network parameter! " + ex.getMessage(), ex);
                LazrsLibMod.LOGGER.error((Object)e);
                throw e;
            }
        }
        in.close();
        return object;
    }
}

